/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.mysql.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.pipeline.mysql.entity.QTrackDocDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class MysqlTrackDocRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QTrackDocDO trackDocDO = QTrackDocDO.trackDocDO;
    private final QBean<TrackDocRespVO> trackDocPagingVO;
    private final QBean<TrackDocRespVO> trackDocVO;

    private Predicate pagingWhere(TrackDocQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(MysqlTrackDocRepoProc.trackDocDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.id.eq((Object)query.getId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTraceId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.traceId.eq((Object)query.getTraceId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestUrl())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestUrl.eq((Object)query.getRequestUrl()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestMethod())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestMethod.eq((Object)query.getRequestMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestHeader())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestHeader.eq((Object)query.getRequestHeader()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestParams())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestParams.eq((Object)query.getRequestParams()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestBody())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestBody.eq((Object)query.getRequestBody()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getResponseData())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.responseData.eq((Object)query.getResponseData()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTrackType())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.trackType.eq((Object)query.getTrackType()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getBizKey())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.bizKey.eq((Object)query.getBizKey()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getAddressIp())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.addressIp.eq((Object)query.getAddressIp()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getEventMessage())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.eventMessage.eq((Object)query.getEventMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getEventParam())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.eventParam.eq((Object)query.getEventParam()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.errorMessage.eq((Object)query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.remark.eq((Object)query.getRemark()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateUserId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCreator())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.creator.eq((Object)query.getCreator()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateTime())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.createTime.eq((Object)query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyUserId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.modifyUserId.eq((Object)query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUpdater())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.updater.eq((Object)query.getUpdater()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyTime())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.modifyTime.eq((Object)query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getDeleteFlag())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.deleteFlag.eq((Object)query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long trackDocCountBy(TrackDocQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(MysqlTrackDocRepoProc.trackDocDO.id).from((EntityPath)trackDocDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.trackDocPagingVO).from((EntityPath)trackDocDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, trackDocDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(TrackDocQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(MysqlTrackDocRepoProc.trackDocDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.id.eq((Object)query.getId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTraceId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.traceId.eq((Object)query.getTraceId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestUrl())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestUrl.eq((Object)query.getRequestUrl()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestMethod())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestMethod.eq((Object)query.getRequestMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestHeader())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestHeader.eq((Object)query.getRequestHeader()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestParams())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestParams.eq((Object)query.getRequestParams()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRequestBody())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.requestBody.eq((Object)query.getRequestBody()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getResponseData())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.responseData.eq((Object)query.getResponseData()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTrackType())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.trackType.eq((Object)query.getTrackType()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getAddressIp())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.addressIp.eq((Object)query.getAddressIp()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getEventMessage())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.eventMessage.eq((Object)query.getEventMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getEventParam())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.eventParam.eq((Object)query.getEventParam()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.errorMessage.eq((Object)query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.remark.eq((Object)query.getRemark()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateUserId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCreator())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.creator.eq((Object)query.getCreator()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateTime())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.createTime.eq((Object)query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyUserId())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.modifyUserId.eq((Object)query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUpdater())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.updater.eq((Object)query.getUpdater()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyTime())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.modifyTime.eq((Object)query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getDeleteFlag())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.deleteFlag.eq((Object)query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.trackDocVO).from((EntityPath)trackDocDO);
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(new OrderSpecifier(Order.DESC, MysqlTrackDocRepoProc.trackDocDO.createTime));
        return jpaQuery.fetch();
    }

    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        if (paramVO.isEmpty()) {
            return 0L;
        }
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(MysqlTrackDocRepoProc.trackDocDO.deleteFlag.eq((Object)0));
        if (CollUtil.isNotEmpty(paramVO.getTraceIds())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.traceId.in(paramVO.getTraceIds()));
        }
        if (ObjectUtil.isNotNull((Object)paramVO.getBeforeTime())) {
            predicates.add(MysqlTrackDocRepoProc.trackDocDO.createTime.lt((Comparable)paramVO.getBeforeTime()));
        }
        JPADeleteClause jpaQuery = this.jpaQueryFactory.delete((EntityPath)trackDocDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return jpaQuery.execute();
    }

    public MysqlTrackDocRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.trackDocPagingVO = Projections.bean(TrackDocRespVO.class, (Expression[])new Expression[]{MysqlTrackDocRepoProc.trackDocDO.id, MysqlTrackDocRepoProc.trackDocDO.traceId, MysqlTrackDocRepoProc.trackDocDO.requestUrl, MysqlTrackDocRepoProc.trackDocDO.requestMethod, MysqlTrackDocRepoProc.trackDocDO.requestHeader, MysqlTrackDocRepoProc.trackDocDO.requestParams, MysqlTrackDocRepoProc.trackDocDO.requestBody, MysqlTrackDocRepoProc.trackDocDO.responseData, MysqlTrackDocRepoProc.trackDocDO.trackType, MysqlTrackDocRepoProc.trackDocDO.bizKey, MysqlTrackDocRepoProc.trackDocDO.addressIp, MysqlTrackDocRepoProc.trackDocDO.eventMessage, MysqlTrackDocRepoProc.trackDocDO.eventParam, MysqlTrackDocRepoProc.trackDocDO.errorMessage, MysqlTrackDocRepoProc.trackDocDO.remark, MysqlTrackDocRepoProc.trackDocDO.createUserId, MysqlTrackDocRepoProc.trackDocDO.creator, MysqlTrackDocRepoProc.trackDocDO.createTime, MysqlTrackDocRepoProc.trackDocDO.modifyUserId, MysqlTrackDocRepoProc.trackDocDO.updater, MysqlTrackDocRepoProc.trackDocDO.modifyTime, MysqlTrackDocRepoProc.trackDocDO.deleteFlag});
        this.trackDocVO = Projections.bean(TrackDocRespVO.class, (Expression[])new Expression[]{MysqlTrackDocRepoProc.trackDocDO.id, MysqlTrackDocRepoProc.trackDocDO.traceId, MysqlTrackDocRepoProc.trackDocDO.requestUrl, MysqlTrackDocRepoProc.trackDocDO.requestMethod, MysqlTrackDocRepoProc.trackDocDO.requestHeader, MysqlTrackDocRepoProc.trackDocDO.requestParams, MysqlTrackDocRepoProc.trackDocDO.requestBody, MysqlTrackDocRepoProc.trackDocDO.responseData, MysqlTrackDocRepoProc.trackDocDO.trackType, MysqlTrackDocRepoProc.trackDocDO.bizKey, MysqlTrackDocRepoProc.trackDocDO.addressIp, MysqlTrackDocRepoProc.trackDocDO.eventMessage, MysqlTrackDocRepoProc.trackDocDO.eventParam, MysqlTrackDocRepoProc.trackDocDO.errorMessage, MysqlTrackDocRepoProc.trackDocDO.remark, MysqlTrackDocRepoProc.trackDocDO.createUserId, MysqlTrackDocRepoProc.trackDocDO.creator, MysqlTrackDocRepoProc.trackDocDO.createTime, MysqlTrackDocRepoProc.trackDocDO.modifyUserId, MysqlTrackDocRepoProc.trackDocDO.updater, MysqlTrackDocRepoProc.trackDocDO.modifyTime, MysqlTrackDocRepoProc.trackDocDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

