/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.infinity.advice;

import com.elitesland.cbpl.logging.infinity.domain.ResponseVO;
import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.lzhpo.tracer.util.TracerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@Order
public class InfinityLogInterceptor
implements ResponseBodyAdvice<ResponseVO> {
    private static final Logger logger = LoggerFactory.getLogger(InfinityLogInterceptor.class);
    @Autowired
    private InfinityTrackService trackService;

    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return ResponseVO.class.isAssignableFrom(returnType.getParameterType());
    }

    public ResponseVO beforeBodyWrite(ResponseVO body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null) {
            body.setTraceId(TracerUtils.getTraceId());
        }
        try {
            this.trackService.record(request, response, body);
        }
        catch (Exception e) {
            logger.error("[LOGGING] INFINITY RESPONSE ERR: {}", (Object)ExceptionUtils.formatException((Throwable)e));
        }
        return body;
    }
}

