package com.elitesland.cbpl.rosefinch.client.config;

import cn.hutool.core.lang.Assert;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author eric.hao
 * @since 2024/10/08
 */
@Data
@ConfigurationProperties(prefix = RosefinchClientProperties.ROSEFINCH_CLIENT_PREFIX)
public class RosefinchClientProperties implements InitializingBean {

    public static final String ROSEFINCH_CLIENT_PREFIX = "cbpl.rosefinch.client";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 消费分组
     */
    private String consumerGroup;

    public static String ROSEFINCH_APP_CODE;
    public static String ROSEFINCH_CONSUMER_GROUP;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notBlank(appCode, "[ROSEFINCH][CONFIG] `cbpl.rosefinch.client.app-code` cannot be null");
        Assert.notBlank(consumerGroup, "[ROSEFINCH][CONFIG] `cbpl.rosefinch.client.consumer-group` cannot be null");
        ROSEFINCH_APP_CODE = appCode;
        ROSEFINCH_CONSUMER_GROUP = consumerGroup;
    }
}
