/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.controller;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.scheduling.constant.InstanceStatus;
import com.elitesland.cbpl.scheduling.data.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstancePagingVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u5b9e\u4f8b"})
@RestController
@RequestMapping(value={"/schedule/instance"})
public class ScheduleInstanceController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleInstanceController.class);
    private final ScheduleInstanceService scheduleInstanceService;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<ScheduleInstancePagingVO>> list(@RequestBody ScheduleInstancePagingParamVO query) {
        logger.info("[PHOENIX-SCHEDULE] query paging param = {}", (Object)query);
        return HttpResult.ok(this.scheduleInstanceService.scheduleInstancePageBy(query));
    }

    @ApiOperation(value="\u7acb\u5373\u7ec8\u6b62")
    @PostMapping(value={"/stop"})
    public HttpResult<Boolean> list(Long instanceId) {
        logger.info("[PHOENIX-SCHEDULE] stop immediately, instanceId = {}", (Object)instanceId);
        ScheduleInstanceDetailVO instance = this.scheduleInstanceService.scheduleInstanceById(instanceId);
        if (!InstanceStatus.RUNNING.getCode().equals(instance.getInstanceStatus())) {
            throw PhoenixException.unchecked((String)("\u5f53\u524d\u5b9e\u4f8b\u72b6\u6001(" + instance.getInstanceStatusName() + ")\u4e0d\u80fd\u7ec8\u6b62"));
        }
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            return HttpResult.ok((Object)this.schedulingRegistrar.stopTriggerInstance(instanceId));
        }
        return HttpResult.ok((Object)Boolean.TRUE);
    }

    @ApiOperation(value="\u5b9e\u4f8b\u72b6\u6001")
    @GetMapping(value={"/status"})
    public HttpResult<List<EnumValues>> status() {
        return HttpResult.ok(InstanceStatus.enumValues());
    }

    public ScheduleInstanceController(ScheduleInstanceService scheduleInstanceService) {
        this.scheduleInstanceService = scheduleInstanceService;
    }
}

