/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.service.impl;

import com.elitesland.cbpl.scheduling.data.convert.ScheduleInstanceConvert;
import com.elitesland.cbpl.scheduling.data.entity.ScheduleInstanceDO;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleInstanceRepo;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleInstanceRepoProc;
import com.elitesland.cbpl.scheduling.data.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstancePagingVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleInstanceServiceImpl
implements ScheduleInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleInstanceServiceImpl.class);
    private final ScheduleInstanceRepo scheduleInstanceRepo;
    private final ScheduleInstanceRepoProc scheduleInstanceRepoProc;

    @Override
    public PagingVO<ScheduleInstancePagingVO> scheduleInstancePageBy(ScheduleInstancePagingParamVO query) {
        long count = this.scheduleInstanceRepoProc.scheduleInstanceCountBy(query);
        if (count > 0L) {
            List<ScheduleInstancePagingVO> list = this.scheduleInstanceRepoProc.scheduleInstancePageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public List<ScheduleInstanceRespVO> scheduleInstanceByParam(ScheduleInstanceQueryParamVO query) {
        return this.scheduleInstanceRepoProc.scheduleInstanceByParam(query);
    }

    @Override
    public ScheduleInstanceDetailVO scheduleInstanceById(Long id) {
        ScheduleInstanceRespVO respVO = this.scheduleInstanceRepoProc.findById(id);
        return ScheduleInstanceConvert.INSTANCE.respToVO(respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Long save(ScheduleInstanceSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            ScheduleInstanceDO scheduleInstanceDO = ScheduleInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            this.scheduleInstanceRepo.save(scheduleInstanceDO);
            return scheduleInstanceDO.getId();
        }
        Optional scheduleInstanceDO = this.scheduleInstanceRepo.findById(saveParam.getId());
        if (scheduleInstanceDO.isEmpty()) {
            throw PhoenixException.unchecked((String)"Not Found Data");
        }
        ScheduleInstanceDO scheduleInstance = (ScheduleInstanceDO)scheduleInstanceDO.get();
        ScheduleInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, scheduleInstance);
        this.scheduleInstanceRepo.save(scheduleInstance);
        return scheduleInstance.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(ScheduleInstanceSaveParamVO saveParam) {
        this.scheduleInstanceRepoProc.update(saveParam);
    }

    public ScheduleInstanceServiceImpl(ScheduleInstanceRepo scheduleInstanceRepo, ScheduleInstanceRepoProc scheduleInstanceRepoProc) {
        this.scheduleInstanceRepo = scheduleInstanceRepo;
        this.scheduleInstanceRepoProc = scheduleInstanceRepoProc;
    }
}

