/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.constant.TenantIsolateStrategy;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.time.LocalDateTime;
import java.util.Objects;

public class SchedulingUtil {
    public static ScheduledTask.ScheduledTaskBuilder registerTask(Class<?> clazz) {
        return ScheduledTask.builder().taskId(SchedulingUtil.getTaskId(clazz)).taskCode(SchedulingUtil.getTaskCode(clazz)).className(clazz.getName());
    }

    public static long getTaskId(Class<?> clazz) {
        int hashCode = Objects.hash(clazz.getName(), Integer.class);
        return Math.abs(hashCode);
    }

    public static String getTaskCode(Class<?> clazz) {
        UnicomTag anno = clazz.getAnnotation(UnicomTag.class);
        return anno.value();
    }

    public static LocalDateTime minusDays(String days) {
        LocalDateTime today = DateUtils.of((String)DateUtil.today(), (String)"yyyy-MM-dd").toLocalDateTime();
        return today.minusDays(Long.parseLong(days));
    }

    public static Object parseArgs(String customArgs) {
        return JSONUtil.wrap((Object)customArgs, (JSONConfig)new JSONConfig());
    }

    public static boolean noTenant() {
        return SchedulingProperties.TENANT_ISOLATE_STRATEGY.equals((Object)TenantIsolateStrategy.NONE) || !SpringUtils.isPresent(TenantClientSpi.class);
    }
}

