/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.registrar.task;

import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.logging.common.constant.DeletionStrategy;
import com.elitesland.cbpl.rosefinch.config.RosefinchProperties;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigQueryParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.enums.InstanceStatus;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.spi.SchedulingDeletionSpi;
import com.elitesland.cbpl.scheduling.spi.SchedulingRegistrarSpi;
import com.elitesland.cbpl.scheduling.util.SchedulingParamUtil;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnicomTag(value="__InstanceDeletionTask")
public class InstanceDeletionTask
implements SchedulingRegistrarSpi,
SchedulingDeletionSpi {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDeletionTask.class);
    private final RosefinchConfigService rosefinchConfigService;
    private final RosefinchInstanceService rosefinchInstanceService;

    @Override
    public boolean autoRegister() {
        return RosefinchProperties.ROSEFINCH_ENABLED;
    }

    @Override
    public ScheduleConfigSaveParamVO registerTask() {
        return SchedulingParamUtil.deletionParamInit(this.getClass(), "\u4efb\u52a1\u4e2d\u5fc3\u5b9e\u4f8b-\u5b9a\u65f6\u5220\u9664", RosefinchProperties.ROSEFINCH_DELETION_CRON);
    }

    @Override
    public void deletion() {
        List tasks = this.rosefinchConfigService.rosefinchConfigByParam(new RosefinchConfigQueryParamVO());
        for (RosefinchConfigDetailVO task : tasks) {
            if (task.getStatus().equals(ActiveStatus.INACTIVE.getCode())) {
                this.deleteInstance(task.getTaskCode(), RosefinchProperties.ROSEFINCH_DELETION_DAYS);
                continue;
            }
            this.deleteInstance(task.getTaskCode(), task.getDeletionStrategy());
        }
    }

    private void deleteInstance(String taskCode, String deletionStrategy) {
        if (DeletionStrategy.NO_DELETION.getDays().equals(deletionStrategy)) {
            logger.warn("[ROSEFINCH] {} deletion strategy: {}", (Object)taskCode, (Object)deletionStrategy);
            return;
        }
        RosefinchInstanceDeleteParamVO deleteParam = new RosefinchInstanceDeleteParamVO();
        deleteParam.setTaskCode(taskCode);
        deleteParam.setInstanceStatus(InstanceStatus.deletionStatus());
        deleteParam.setBeforeTime(SchedulingUtil.minusDays(deletionStrategy));
        this.rosefinchInstanceService.deleteInstance(deleteParam, "AUTO");
    }

    public InstanceDeletionTask(RosefinchConfigService rosefinchConfigService, RosefinchInstanceService rosefinchInstanceService) {
        this.rosefinchConfigService = rosefinchConfigService;
        this.rosefinchInstanceService = rosefinchInstanceService;
    }
}

