/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.controller;

import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/schedule/config"})
public class ScheduleConfigController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfigController.class);
    private final ScheduleConfigService scheduleConfigService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<ScheduleConfigPagingVO>> list(@RequestBody ScheduleConfigPagingParamVO query) {
        logger.info("[SCHEDULE] query paging param = {}", (Object)query);
        return HttpResult.ok(this.scheduleConfigService.scheduleConfigPageBy(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<ScheduleConfigDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[SCHEDULE] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.scheduleConfigService.scheduleConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody @Valid ScheduleConfigSaveParamVO saveParam) {
        logger.info("[SCHEDULE] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.scheduleConfigService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[SCHEDULE] active by id = {}", (Object)id);
        this.scheduleConfigService.active(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[SCHEDULE] inactive by id = {}", (Object)id);
        this.scheduleConfigService.inactive(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete/physical"})
    public HttpResult<Void> delete(@RequestBody List<Long> ids) {
        logger.info("[SCHEDULE] batch physical delete by ids = {}", ids);
        this.scheduleConfigService.delete(ids);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4e00\u6b21")
    @PostMapping(value={"/execute"})
    public HttpResult<Void> execute(Long taskId) {
        logger.info("[SCHEDULE] execute immediately, taskId = {}", (Object)taskId);
        this.scheduleConfigService.execute(taskId);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u79fb\u9664\u5e76\u7ec8\u6b62\u4efb\u52a1")
    @PostMapping(value={"/remove"})
    public HttpResult<Boolean> stop(String taskCode) {
        logger.info("[SCHEDULE] stop taskCode = {}", (Object)taskCode);
        return HttpResult.ok((Object)this.scheduleConfigService.stopImmediately(taskCode));
    }

    @ApiOperation(value="CRON\u8868\u8fbe\u5f0f\u9884\u89c8")
    @GetMapping(value={"/cron/preview"})
    public HttpResult<List<String>> preview(Long taskId) {
        logger.info("[SCHEDULE] cron preview, taskId = {}", (Object)taskId);
        return HttpResult.ok(this.scheduleConfigService.preview(taskId));
    }

    @ApiOperation(value="\u6240\u6709\u4efb\u52a1\u5217\u8868")
    @GetMapping(value={"/task/list"})
    public HttpResult<Set<String>> taskCodes() {
        logger.info("[SCHEDULE] query all tenant taskCodes.");
        return HttpResult.ok(this.scheduleConfigService.taskCodes());
    }

    public ScheduleConfigController(ScheduleConfigService scheduleConfigService) {
        this.scheduleConfigService = scheduleConfigService;
    }
}

