/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class DefaultSchedulingRegistrar
implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulingRegistrar.class);
    private ScheduledTaskRegistrar taskRegistrar;
    private final Map<String, ScheduledFuture<?>> taskFutures = new ConcurrentHashMap();
    @Resource
    private ScheduledExecutorService phoenixScheduleTp;

    public void configureTasks(@NotNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.phoenixScheduleTp);
        this.taskRegistrar = taskRegistrar;
    }

    public void runImmediately(ScheduledTask task) {
        RosefinchConfigService rosefinchConfigService = (RosefinchConfigService)SpringUtils.getBean(RosefinchConfigService.class);
        rosefinchConfigService.execute(task.taskRequestParam());
    }

    public void addTriggerTask(ScheduledTask task) {
        RosefinchConfigService rosefinchConfigService = (RosefinchConfigService)SpringUtils.getBean(RosefinchConfigService.class);
        String taskFutureKey = this.taskFutureKey(task.getTaskCode());
        if (this.taskFutures.containsKey(taskFutureKey)) {
            throw new SchedulingException("[SCHEDULE] taskCode[" + task.getTaskCode() + "] was added.");
        }
        TaskScheduler scheduler = this.taskRegistrar.getScheduler();
        ScheduledFuture future = scheduler.schedule(rosefinchConfigService.runAuto(task.taskRequestParam()), (Trigger)task.getTrigger());
        this.taskFutures.put(taskFutureKey, future);
        logger.info("[SCHEDULE] add taskCode[{}] success.", (Object)task.getTaskCode());
    }

    public void cancelTriggerTask(ScheduledTask task) {
        if (!this.hasTask(task.getTaskCode())) {
            logger.info("[SCHEDULE] taskCode[{}] not exist to cancel.", (Object)task.getTaskCode());
            return;
        }
        boolean cancelTag = this.stopImmediately(task.getTaskCode(), false);
        logger.info("[SCHEDULE] taskCode[{}] canceled {}.", (Object)task.getTaskCode(), (Object)cancelTag);
    }

    public boolean stopTriggerTask(ScheduledTask task) {
        if (!this.hasTask(task.getTaskCode())) {
            logger.warn("[SCHEDULE] taskCode[{}] not exist to stop.", (Object)task.getTaskCode());
            return true;
        }
        boolean stopTag = this.stopImmediately(task.getTaskCode(), true);
        logger.info("[SCHEDULE] taskCode[{}] stopped {}.", (Object)task.getTaskCode(), (Object)stopTag);
        return stopTag;
    }

    public boolean stopImmediately(String taskCode, boolean mayInterruptIfRunning) {
        if (!this.hasTask(taskCode)) {
            logger.info("[SCHEDULE] taskCode[{}] not exist to stop.", (Object)taskCode);
            return false;
        }
        String taskFutureKey = this.taskFutureKey(taskCode);
        ScheduledFuture<?> future = this.taskFutures.get(taskFutureKey);
        boolean cancelTag = future.cancel(mayInterruptIfRunning);
        if (cancelTag) {
            this.taskFutures.remove(taskFutureKey);
        }
        return cancelTag;
    }

    public void resetTriggerTask(ScheduledTask task) {
        this.cancelTriggerTask(task);
        this.addTriggerTask(task);
    }

    public Set<String> taskCodes() {
        return this.taskFutures.keySet();
    }

    public boolean hasTask(String taskCode) {
        return this.taskFutures.containsKey(this.taskFutureKey(taskCode));
    }

    public boolean initializeCompleted() {
        return this.taskRegistrar != null && this.taskRegistrar.getScheduler() != null;
    }

    private String taskFutureKey(String taskCode) {
        if (RosefinchUtil.noTenant()) {
            return taskCode;
        }
        return StringUtils.tenantKey((String[])new String[]{taskCode});
    }
}

