/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.scheduling.constant.TenantIsolateStrategy;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cbpl.schedule")
public class SchedulingProperties
implements InitializingBean {
    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.schedule";
    private boolean enabled;
    private boolean cluster;
    private int expireDuration = 10;
    private int corePoolSize = 4;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private int queueCapacity = 1024;
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();
    private String deletionStrategyCron = "0 20 1 * * ?";
    private boolean isQueryBuildIn;
    private String queueSolution = "default";
    private TenantIsolateStrategy tenantIsolateStrategy = TenantIsolateStrategy.NONE;
    public static boolean SCHEDULE_ENABLED;
    public static boolean SCHEDULE_CLUSTER;
    public static int SCHEDULE_EXPIRE_DURATION;
    public static String SCHEDULE_DELETION_CRON;
    public static boolean IS_QUERY_BUILD_IN;
    public static TenantIsolateStrategy TENANT_ISOLATE_STRATEGY;

    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = this.enabled;
        SCHEDULE_CLUSTER = this.cluster;
        SCHEDULE_EXPIRE_DURATION = this.expireDuration;
        SCHEDULE_DELETION_CRON = this.deletionStrategyCron;
        IS_QUERY_BUILD_IN = this.isQueryBuildIn;
        TENANT_ISOLATE_STRATEGY = this.tenantIsolateStrategy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public int getExpireDuration() {
        return this.expireDuration;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public String getRejectPolicy() {
        return this.rejectPolicy;
    }

    public String getDeletionStrategyCron() {
        return this.deletionStrategyCron;
    }

    public boolean isQueryBuildIn() {
        return this.isQueryBuildIn;
    }

    public String getQueueSolution() {
        return this.queueSolution;
    }

    public TenantIsolateStrategy getTenantIsolateStrategy() {
        return this.tenantIsolateStrategy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public void setExpireDuration(int expireDuration) {
        this.expireDuration = expireDuration;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectPolicy(String rejectPolicy) {
        this.rejectPolicy = rejectPolicy;
    }

    public void setDeletionStrategyCron(String deletionStrategyCron) {
        this.deletionStrategyCron = deletionStrategyCron;
    }

    public void setQueryBuildIn(boolean isQueryBuildIn) {
        this.isQueryBuildIn = isQueryBuildIn;
    }

    public void setQueueSolution(String queueSolution) {
        this.queueSolution = queueSolution;
    }

    public void setTenantIsolateStrategy(TenantIsolateStrategy tenantIsolateStrategy) {
        this.tenantIsolateStrategy = tenantIsolateStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingProperties)) {
            return false;
        }
        SchedulingProperties other = (SchedulingProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isCluster() != other.isCluster()) {
            return false;
        }
        if (this.getExpireDuration() != other.getExpireDuration()) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.isQueryBuildIn() != other.isQueryBuildIn()) {
            return false;
        }
        String this$rejectPolicy = this.getRejectPolicy();
        String other$rejectPolicy = other.getRejectPolicy();
        if (this$rejectPolicy == null ? other$rejectPolicy != null : !this$rejectPolicy.equals(other$rejectPolicy)) {
            return false;
        }
        String this$deletionStrategyCron = this.getDeletionStrategyCron();
        String other$deletionStrategyCron = other.getDeletionStrategyCron();
        if (this$deletionStrategyCron == null ? other$deletionStrategyCron != null : !this$deletionStrategyCron.equals(other$deletionStrategyCron)) {
            return false;
        }
        String this$queueSolution = this.getQueueSolution();
        String other$queueSolution = other.getQueueSolution();
        if (this$queueSolution == null ? other$queueSolution != null : !this$queueSolution.equals(other$queueSolution)) {
            return false;
        }
        TenantIsolateStrategy this$tenantIsolateStrategy = this.getTenantIsolateStrategy();
        TenantIsolateStrategy other$tenantIsolateStrategy = other.getTenantIsolateStrategy();
        return !(this$tenantIsolateStrategy == null ? other$tenantIsolateStrategy != null : !((Object)((Object)this$tenantIsolateStrategy)).equals((Object)other$tenantIsolateStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulingProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isCluster() ? 79 : 97);
        result = result * 59 + this.getExpireDuration();
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + (this.isQueryBuildIn() ? 79 : 97);
        String $rejectPolicy = this.getRejectPolicy();
        result = result * 59 + ($rejectPolicy == null ? 43 : $rejectPolicy.hashCode());
        String $deletionStrategyCron = this.getDeletionStrategyCron();
        result = result * 59 + ($deletionStrategyCron == null ? 43 : $deletionStrategyCron.hashCode());
        String $queueSolution = this.getQueueSolution();
        result = result * 59 + ($queueSolution == null ? 43 : $queueSolution.hashCode());
        TenantIsolateStrategy $tenantIsolateStrategy = this.getTenantIsolateStrategy();
        result = result * 59 + ($tenantIsolateStrategy == null ? 43 : ((Object)((Object)$tenantIsolateStrategy)).hashCode());
        return result;
    }

    public String toString() {
        return "SchedulingProperties(enabled=" + this.isEnabled() + ", cluster=" + this.isCluster() + ", expireDuration=" + this.getExpireDuration() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueCapacity=" + this.getQueueCapacity() + ", rejectPolicy=" + this.getRejectPolicy() + ", deletionStrategyCron=" + this.getDeletionStrategyCron() + ", isQueryBuildIn=" + this.isQueryBuildIn() + ", queueSolution=" + this.getQueueSolution() + ", tenantIsolateStrategy=" + this.getTenantIsolateStrategy() + ")";
    }
}

