/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.ScheduleInitialize;
import com.elitesland.cbpl.scheduling.service.ScheduleExecuteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SchedulingProperties.class})
@ConditionalOnProperty(prefix="cbpl.tool.schedule", name={"enabled"}, havingValue="true")
public class SchedulingAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingAutoConfiguration.class);

    @Bean
    public ScheduleExecuteHandler scheduleExecuteHandler() {
        return new ScheduleExecuteHandler();
    }

    @Bean
    public DefaultSchedulingRegistrar defaultSchedulingRegistrar(ScheduleExecuteHandler scheduleExecuteHandler) {
        logger.info("[PHOENIX-SCHEDULE] Scheduling enabled.");
        return new DefaultSchedulingRegistrar(scheduleExecuteHandler);
    }

    @Bean
    public ScheduleInitialize scheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        logger.info("[PHOENIX-SCHEDULE] Scheduling Initialize loading...");
        ScheduleInitialize schedule = new ScheduleInitialize(schedulingRegistrar);
        logger.info("[PHOENIX-SCHEDULE] Scheduling Initialize finished.");
        return schedule;
    }
}

