/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.domain;

import cn.hutool.extra.spring.SpringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.config.TriggerTask;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.ReflectionUtils;

@ApiModel(value="\u4efb\u52a1\u7ba1\u7406")
public class ScheduledTask {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    @ApiModelProperty(value="\u4efb\u52a1ID")
    private Long taskId;
    @ApiModelProperty(value="\u4efb\u52a1\u540d\u79f0")
    private String taskName;
    @ApiModelProperty(value="\u4efb\u52a1\u7f16\u7801")
    private String taskCode;
    @ApiModelProperty(value="\u89e6\u53d1\u4efb\u52a1")
    private TriggerTask triggerTask;

    public ScheduledTask setTrigger(String className, String methodName, String cron) {
        this.triggerTask = new TriggerTask(() -> {
            Object bean = SpringUtil.getBean((String)className);
            Method method = ReflectionUtils.findMethod(bean.getClass(), (String)methodName);
            ReflectionUtils.invokeMethod((Method)method, (Object)bean);
        }, triggerContext -> {
            CronTrigger trigger = new CronTrigger(cron);
            return trigger.nextExecutionTime(triggerContext);
        });
        return this;
    }

    ScheduledTask(Long taskId, String taskName, String taskCode, TriggerTask triggerTask) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.taskCode = taskCode;
        this.triggerTask = triggerTask;
    }

    public static ScheduledTaskBuilder builder() {
        return new ScheduledTaskBuilder();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public TriggerTask getTriggerTask() {
        return this.triggerTask;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public void setTriggerTask(TriggerTask triggerTask) {
        this.triggerTask = triggerTask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledTask)) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$taskCode = this.getTaskCode();
        String other$taskCode = other.getTaskCode();
        if (this$taskCode == null ? other$taskCode != null : !this$taskCode.equals(other$taskCode)) {
            return false;
        }
        TriggerTask this$triggerTask = this.getTriggerTask();
        TriggerTask other$triggerTask = other.getTriggerTask();
        return !(this$triggerTask == null ? other$triggerTask != null : !this$triggerTask.equals(other$triggerTask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $taskCode = this.getTaskCode();
        result = result * 59 + ($taskCode == null ? 43 : $taskCode.hashCode());
        TriggerTask $triggerTask = this.getTriggerTask();
        result = result * 59 + ($triggerTask == null ? 43 : $triggerTask.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledTask(taskId=" + this.getTaskId() + ", taskName=" + this.getTaskName() + ", taskCode=" + this.getTaskCode() + ", triggerTask=" + this.getTriggerTask() + ")";
    }

    public static class ScheduledTaskBuilder {
        private Long taskId;
        private String taskName;
        private String taskCode;
        private TriggerTask triggerTask;

        ScheduledTaskBuilder() {
        }

        public ScheduledTaskBuilder taskId(Long taskId) {
            this.taskId = taskId;
            return this;
        }

        public ScheduledTaskBuilder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public ScheduledTaskBuilder taskCode(String taskCode) {
            this.taskCode = taskCode;
            return this;
        }

        public ScheduledTaskBuilder triggerTask(TriggerTask triggerTask) {
            this.triggerTask = triggerTask;
            return this;
        }

        public ScheduledTask build() {
            return new ScheduledTask(this.taskId, this.taskName, this.taskCode, this.triggerTask);
        }

        public String toString() {
            return "ScheduledTask.ScheduledTaskBuilder(taskId=" + this.taskId + ", taskName=" + this.taskName + ", taskCode=" + this.taskCode + ", triggerTask=" + this.triggerTask + ")";
        }
    }
}

