/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.cron.pattern.CronPatternUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.scheduling.convert.ScheduleConfigConvert;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.repo.ScheduleConfigRepo;
import com.elitesland.cbpl.scheduling.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScheduleConfigServiceImpl
implements ScheduleConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfigServiceImpl.class);
    private final ScheduleConfigRepo scheduleConfigRepo;
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @Override
    @SysCodeProc
    public PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        long count = this.scheduleConfigRepoProc.scheduleConfigCountBy(query);
        if (count > 0L) {
            List<ScheduleConfigPagingVO> list = this.scheduleConfigRepoProc.scheduleConfigPageBy(query);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    @SysCodeProc
    public List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        List<ScheduleConfigRespVO> tasks = this.scheduleConfigRepoProc.scheduleConfigByParam(query);
        return tasks.stream().map(row -> ScheduledTask.builder().taskId(row.getId()).taskCode(row.getTaskCode()).taskName(row.getTaskName()).build().setTrigger(row.getClassName(), row.getMethod(), row.getCron())).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public ScheduleConfigDetailVO scheduleConfigById(Long id) {
        ScheduleConfigRespVO scheduleConfigVO = this.scheduleConfigRepoProc.findById(id);
        if (ObjectUtil.isNull((Object)scheduleConfigVO)) {
            throw new BusinessException(ApiCode.NOT_FOUND_DATA, "Not Found Data");
        }
        return ScheduleConfigConvert.INSTANCE.respToVO(scheduleConfigVO);
    }

    private ScheduledTask scheduledByTaskId(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        return ScheduledTask.builder().taskId(taskId).taskCode(schedule.getTaskCode()).taskName(schedule.getTaskName()).build().setTrigger(schedule.getClassName(), schedule.getMethod(), schedule.getCron());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ScheduleConfigSaveParamVO saveParam) {
        ScheduledTask task = ScheduledTask.builder().taskId(saveParam.getId()).taskCode(saveParam.getTaskCode()).taskName(saveParam.getTaskName()).build().setTrigger(saveParam.getClassName(), saveParam.getMethod(), saveParam.getCron());
        if (saveParam.isNew()) {
            ScheduleConfigDO scheduleConfigDO = ScheduleConfigConvert.INSTANCE.saveParamToDO(saveParam);
            this.scheduleConfigRepo.save(scheduleConfigDO);
            this.addTriggerTask(task);
            return scheduleConfigDO.getId();
        }
        Optional scheduleConfigDO = this.scheduleConfigRepo.findById(saveParam.getId());
        if (scheduleConfigDO.isEmpty()) {
            throw new BusinessException(ApiCode.NOT_FOUND_DATA, "Not Found Data");
        }
        ScheduleConfigDO scheduleConfig = (ScheduleConfigDO)scheduleConfigDO.get();
        ScheduleConfigConvert.INSTANCE.saveParamMergeToDO(saveParam, scheduleConfig);
        this.scheduleConfigRepo.save(scheduleConfig);
        this.resetTriggerTask(task);
        return scheduleConfig.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, String status) {
        this.scheduleConfigRepoProc.updateStatus(id, status);
        if (status.equals("0")) {
            this.cancelTriggerTask(this.scheduledByTaskId(id));
        } else if (status.equals("1")) {
            this.resetTriggerTask(this.scheduledByTaskId(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateDeleteFlag(List<Long> ids) {
        ids.stream().map(this::scheduledByTaskId).forEach(this::cancelTriggerTask);
        return this.scheduleConfigRepoProc.updateDeleteFlag(ids);
    }

    @Override
    public void execute(Long taskId) {
        try {
            this.runImmediately(this.scheduledByTaskId(taskId));
        }
        catch (RuntimeException e) {
            throw new BusinessException("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute once error: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            throw new BusinessException("\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    @Override
    public List<String> preview(Long taskId) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigById(taskId);
        List dates = CronPatternUtil.matchedDates((String)schedule.getCron(), (Date)new Date(), (int)20, (boolean)true);
        return dates.stream().map(DateUtil::formatDateTime).collect(Collectors.toList());
    }

    private void addTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.addTriggerTask(task);
        }
    }

    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.resetTriggerTask(task);
        }
    }

    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.cancelTriggerTask(task);
        }
    }

    private void runImmediately(ScheduledTask task) {
        if (ObjectUtil.isNull((Object)this.schedulingRegistrar)) {
            throw new RuntimeException("Phoenix-Schedule\u6a21\u5757\u672a\u5f00\u542f");
        }
        this.schedulingRegistrar.runImmediately(task);
    }

    public ScheduleConfigServiceImpl(ScheduleConfigRepo scheduleConfigRepo, ScheduleConfigRepoProc scheduleConfigRepoProc) {
        this.scheduleConfigRepo = scheduleConfigRepo;
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
    }
}

