package com.elitesland.cbpl.sns.bot.config;

import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.support.CustomMessage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.text.MessageFormat;

import static com.github.jaemon.dinger.constant.DingerConstant.MARKDOWN_MESSAGE;

/**
 * @author eric.hao
 * @since 2023/07/05
 */
@Configuration
public class SnsBotConfig {

    @Bean(MARKDOWN_MESSAGE)
    public CustomMessage markDownMessage() {
        return (String projectId, DingerRequest request) -> {
            StringBuilder text = new StringBuilder("##### " + request.getTitle());
            return MessageFormat.format(" {0}\n{1}", text, request.getContent());
        };
    }
}
