package com.elitesland.cbpl.sns.bot.service;

import com.elitesland.cbpl.sns.bot.util.SnsBotUtil;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.github.jaemon.dinger.DingerSender;
import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2023/07/05
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SnsBotService {

    private final DingerSender dingerSender;

    /**
     * 推送异常告警
     *
     * @param request 告警报文
     */
    public void error(BotRequest request) {
        DingerRequest msgReq = DingerRequest.request(SnsBotUtil.parseErrorMsg(request), request.getSnsTitle());
        logger.error("[SNS] bot request: {}", BeanUtils.toJsonStr(msgReq));
        dingerSender.send(MessageSubType.MARKDOWN, msgReq);
    }
}
