package com.elitesland.cbpl.sns.bot.tims.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2023/06/28
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "cbpl.tims.track")
public class TimsTrackConfig implements InitializingBean {

    @ApiModelProperty("索引策略(名称)")
    private String policyName;

    @ApiModelProperty("滚动更新别名")
    private String rolloverAlias;

    public static String TIMS_TRACK_POLICY_NAME;
    public static String TIMS_TRACK_ROLLOVER_ALIAS;

    @Override
    public void afterPropertiesSet() {
        TIMS_TRACK_POLICY_NAME = policyName;
        TIMS_TRACK_ROLLOVER_ALIAS = rolloverAlias;
    }
}
