package com.elitesland.cbpl.sns.bot.tims.service;

import com.elitesland.cbpl.sns.bot.domain.BotMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.service.SnsBotService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.function.Supplier;

/**
 * Tims 告警机器人
 *
 * @author eric.hao
 * @since 2023/07/05
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BotSender {

    private static final int SEGMENT_LEN = 256;

    /**
     * 机器人消息推送
     */
    private final SnsBotService snsBotService;

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param message     告警信息
     */
    public void push(Supplier<BotRequest> botSupplier, String message) {
        try {
            BotMessage botMessage = new BotMessage();
            botMessage.setBizKey("");
            botMessage.setMessages(List.of(message));
            BotRequest request = botSupplier.get();
            request.setMessages(List.of(botMessage));
            snsBotService.error(request);
        } catch (Exception e) {
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", ExceptionUtils.formatException(e));
        }
    }

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param messages    告警信息
     */
    public void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        try {
            BotRequest request = botSupplier.get();
            request.setMessages(messages);
            snsBotService.error(request);
        } catch (Exception e) {
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", ExceptionUtils.formatException(e));
        }
    }

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param e           异常堆栈
     */
    public void push(Supplier<BotRequest> botSupplier, Exception e) {
        push(botSupplier, ExceptionUtils.stacktraceToOneLineString(e, SEGMENT_LEN));
    }
}
