package com.elitesland.cbpl.sns.bot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.sns.bot.domain.BotMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/07/05
 */
public class SnsBotUtil {

    public static String parseErrorMsg(BotRequest request) {
        return "> 调用方式：" + request.getSnsMode() + StrPool.LF +
                "> 异常类型：<font color='red'>" + request.getSnsType() + "</font>" + StrPool.LF +
                "> 异常单据类型：" + request.getSnsScene() + StrPool.LF +
                "> 时间：" + DateUtils.nowStr() + StrPool.LF +
                "> TraceID：" + TraceContext.traceId() + StrPool.LF +
                "> 异常信息：" + concat(request.getMessages());
    }

    private static String concat(List<BotMessage> messages) {
        if (CollUtil.isEmpty(messages)) {
            return "无";
        }
        return messages.stream().map(msg -> {
            String text = StrPool.LF + "**<font color='red'>" + msg.getBizKey() + "</font>** ";
            return text + StrUtil.join("；", msg.getMessages());
        }).reduce("", String::concat);
    }
}
