package com.elitesland.cbpl.sns.inbox.config;

import com.elitesland.cbpl.sns.inbox.repo.InboxMongoStorer;
import com.elitesland.cbpl.sns.inbox.repo.InboxStorer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * 站内消息持久服务
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Configuration
public class InboxConfig {

    @Bean
    @ConditionalOnMissingBean
    InboxStorer inboxStorer(MongoTemplate mongoTemplate) {
        logger.info("[IM-SNS] edpSnsInboxStorer");
        return new InboxMongoStorer(mongoTemplate);
    }
}
