package com.elitesland.cbpl.sns.inbox.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPayload;
import com.elitesland.cbpl.sns.notifier.service.SnsService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.Collections;

import static com.elitesland.cbpl.sns.inbox.domain.InboxType.*;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@RestController
@RequestMapping("/devops")
@RequiredArgsConstructor
public class DemoApi {

    private final SnsService templateService;

    @GetMapping("/ws/one")
    public ApiResult<?> pushOne(String msgCode, String toUserId) {
        var inboxPayload = InboxPayload.builder()
                .time(LocalDateTime.now())
                .type(INBOX_TODO)
                .subject("测试标题")
                .content("测试内容")
                .from("0")
                .tos(Collections.singleton(toUserId))
                .build();
        templateService.sendMessage(INBOX_INFO, msgCode, Collections.singleton(toUserId), inboxPayload);
        return ApiResult.ok();
    }
}
