package com.elitesland.cbpl.sns.inbox.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.cloudt.iam.IamUserUtil;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.repo.InboxReader;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 站内消息查询服务
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Api(tags = "消息数据服务")
@Slf4j
@RestController
@RequestMapping("/sns")
@RequiredArgsConstructor
public class InboxController {

    private final InboxReader inboxReader;

    @GetMapping("/inbox-count")
    public Map<InboxType, Long> countUnread() {
        Long userId = IamUserUtil.currentUserId();
        return inboxReader.countUnread(String.valueOf(userId), InboxType.getStoreTypes());
    }

    @PostMapping("/inbox")
    public PagingVO<? extends InboxSaveParamVO> find(@RequestBody InboxPageParamVO query) {
        if (query.getRecipientId() == null) {
            Long userId = IamUserUtil.currentUserId();
            query.setRecipientId(String.valueOf(userId));
        }
        return inboxReader.find(query);
    }

    @PatchMapping("/inbox/{type}/messages/{id}")
    public Optional<? extends InboxSaveParamVO> read(
        @PathVariable InboxType type, @PathVariable("id") String messageId) {
        Long userId = IamUserUtil.currentUserId();
        return inboxReader.read(type, messageId, String.valueOf(userId));
    }

    @GetMapping("/inbox/mp/{type}/messages/{id}")
    public Optional<? extends InboxSaveParamVO> readbyMp(
            @PathVariable InboxType type, @PathVariable("id") String messageId) {
        Long userId = IamUserUtil.currentUserId();
        return inboxReader.read(type, messageId, String.valueOf(userId));
    }

    @PatchMapping("/inbox/{type}/allMessages")
    public ApiResult<Void> readAllMessages(@PathVariable InboxType type) {
        Long userId = IamUserUtil.currentUserId();
        return inboxReader.readAllMessages(type, String.valueOf(userId));
    }

    @PostMapping("/inbox/msgType")
    public ApiResult<List<Map<String, String>>> getMsgType() {
        return ApiResult.ok(inboxReader.getMsgType());
    }

}
