package com.elitesland.cbpl.sns.inbox.domain;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
public enum InboxType implements InboxDef {

    INBOX_STAT("分类统计消息") {
        @Override
        public String getStoreName() {
            return null;
        }
    },
    INBOX_INFO("消息"),
    INBOX_TODO("待办"),
    INBOX_WARN("告警"),

    // 驱逐登录用户
    EVICT_LOGIN("取消登录"),
    EVICT_RESET("用户重置"),
    ;

    /**
     * 消息类型名
     */
    @Getter
    private final String name;

    InboxType(String name) {
        this.name = name;
    }

    @Override
    public String getCode() {
        return name();
    }

    public static Stream<InboxType> getStoreTypes() {
        return Stream.of(InboxType.values())
            .filter(v -> v.getStoreName() != null);
    }
}
