package com.elitesland.cbpl.sns.inbox.pusher;

import com.elitesland.cbpl.sns.inbox.repo.InboxStorer;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Service
@RequiredArgsConstructor
public class InboxDefaultPusher implements InboxPusher {

    private final WebSocketNotifier notifier;

    @Autowired(required = false)
    private InboxStorer storer;

    @Override
    public void push(InboxSaveParamVO payload) {
        if (storer != null) {
            storer.save(payload);
        }
        notifier.notify(payload);
    }
}
