package com.elitesland.cbpl.sns.inbox.repo;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.BeanUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.mongo.InboxPageQuery;
import com.elitesland.cbpl.sns.inbox.mongo.InboxUnreadQuery;
import com.elitesland.cbpl.sns.inbox.util.InboxUtil;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.sns.inbox.vo.resp.InboxRespVO;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import com.elitesland.cbpl.sns.template.entity.MsgTemplateDO;
import com.elitesland.cbpl.sns.template.entity.MsgTemplateLinkDO;
import com.elitesland.cbpl.sns.template.repo.MsgTemplateLinkRepo;
import com.elitesland.cbpl.sns.template.repo.MsgTemplateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InboxMongoReader implements InboxReader {

    private final MongoTemplate mongoTemplate;
    private final MsgTemplateRepo msgTemplateRepo;
    private final MsgTemplateLinkRepo msgTemplateLinkRepo;
    private final InboxUtil inboxUtil;

//    private final EdpNameService nameService;

    private Class<InboxRespVO> getEntityClass() {
        return InboxRespVO.class;
    }

    @Override
    public Map<InboxType, Long> countUnread(String reader, Stream<InboxType> types) {
        return types.collect(Collectors.toMap(
                type -> type,
                type -> InboxUnreadQuery.builder()
                        .type(type).reader(reader)
                        .build().count(mongoTemplate)
        ));
    }

    @Override
    public PagingVO<? extends InboxSaveParamVO> find(InboxPageParamVO params) {
        val result = InboxPageQuery.builder().params(params)
                .build().paging(mongoTemplate, getEntityClass());
//        nameService.resolveNames(result.getRows());
        // 处理已读未读，存在一个消息多个收件人，某个收件人已读问题
        if (result.getTotal() > 0) {
            List<InboxRespVO> records = result.getRecords();
            Map<String, List<MsgTemplateDO>> tmplList = msgTemplateRepo.findAll().stream().collect(Collectors.groupingBy(MsgTemplateDO::getTmplCode));
            Map<String, List<MsgTemplateLinkDO>> templateLinkList = msgTemplateLinkRepo.findAll().stream().collect(Collectors.groupingBy(MsgTemplateLinkDO::getLinkCode));
            records.forEach(record -> {
                Map<String, Object> extInfo = BeanUtils.beanToMap(record.getExtInfo());
                if (extInfo.get("eventType") != null) {
                    extInfo.put("msgTypeName", CollectionUtils.isNotEmpty(tmplList.get(extInfo.get("eventType").toString()))
                            ? tmplList.get(extInfo.get("eventType").toString()).get(0).getTmplName() : "");
                    String tempCode = CollectionUtils.isNotEmpty(tmplList.get(extInfo.get("eventType").toString())) ?
                            tmplList.get(extInfo.get("eventType").toString()).get(0).getTmplDesc() : "";
                    if (StringUtils.isNotEmpty(tempCode)) {
                        extInfo.put("linkUrl2", CollectionUtils.isNotEmpty(templateLinkList.get(tempCode)) ?
                                templateLinkList.get(tempCode).get(0).getLinkVal2() : "");
                    }
                }
                if (extInfo.get("linkUrl") == null && StringUtils.isNotEmpty(record.getContent())) {
                    String linkUrl = inboxUtil.getTempLinkUrl(record.getContent());
                    extInfo.put("linkUrl", linkUrl);
                }
                record.setExtInfo(extInfo);
                record.setReadFlag(!record.getRead().isEmpty() && record.getRead().size() > 0 && record.getRead().containsKey(params.getRecipientId()));
            });
        }
        return result;
    }

    @Override
    public Optional<? extends InboxSaveParamVO> read(InboxType type, String messageId, String reader) {
        val message = mongoTemplate.findById(messageId, getEntityClass(), type.getStoreName());
        if (message == null) {
            return Optional.empty();
        }

        val update = Update.update("read." + reader, Instant.now());
        val query = Query.query(
                where("_id").is(messageId).orOperator(
                        where("tos").size(0),
                        where("tos").is(reader)));
        mongoTemplate.findAndModify(query, update, getEntityClass(), type.getStoreName());
        return Optional.of(message);
    }

    @Override
    public ApiResult<Void> readAllMessages(InboxType type, String reader) {
        val update = Update.update("read." + reader, Instant.now());
        val query = Query.query(new Criteria().orOperator(
                where("tos").size(0),
                where("tos").is(reader)));
        mongoTemplate.updateMulti(query, update, getEntityClass(), type.getStoreName());
        return ApiResult.ok();
    }

    @Override
    public List<Map<String, String>> getMsgType() {
        List<MsgTemplateDO> tmplDo = msgTemplateRepo.findAll();
        List<Map<String, String>> result = new ArrayList<>();
        tmplDo.forEach(tmpl -> {
            Map<String, String> map = new HashMap<>();
            map.put("code", tmpl.getTmplCode());
            map.put("name", tmpl.getTmplName());
            result.add(map);
        });
        return result;
    }

}
