package com.elitesland.cbpl.sns.inbox.repo;

import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@RequiredArgsConstructor
public class InboxMongoStorer implements InboxStorer {

    private final MongoTemplate mongoTemplate;

    @Override
    public void save(InboxSaveParamVO payload) {
        mongoTemplate.insert(payload, payload.getType().getStoreName());
    }
}
