package com.elitesland.cbpl.sns.inbox.repo;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 站内信箱读取者
 *
 * @author eric.hao
 * @since 2022/09/15
 */
public interface InboxReader {

    /**
     * @param reader 收件人
     * @param types  消息类型
     * @return 每种类型的未读计数
     */
    Map<InboxType, Long> countUnread(String reader, Stream<InboxType> types);

    /**
     * @param params 查询参数
     * @return 查询结果
     */
    PagingVO<? extends InboxSaveParamVO> find(InboxPageParamVO params);

    /**
     * @param type      消息类型
     * @param messageId 消息ID
     * @param reader    收信人
     * @return 消息
     */
    Optional<? extends InboxSaveParamVO> read(InboxType type, String messageId, String reader);

    /**
     * 全部已读
     * @param type 消息类型
     * @param reader 收信人
     * @return
     */
    ApiResult<Void> readAllMessages(InboxType type, String reader);

    /**
     * 消息类型下拉
     * @return
     */
    List<Map<String, String>> getMsgType();
}
