package com.elitesland.cbpl.sns.inbox.service;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.pusher.InboxPusher;
import com.elitesland.cbpl.sns.notifier.vo.payload.SnsPayload;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InboxServiceImpl implements InboxService {

    private final InboxPusher inboxPusher;

    @Override
    public void sendInbox(InboxType inboxType, Set<String> tos, SnsPayload payload) {
        if (!payload.isValid()) {
            logger.info("[IM-SNS] INBOX message payload is empty.");
            return;
        }
        try {
            logger.info("[IM-SNS] INBOX message to userId={} sending...", tos);
            val inboxPayload = InboxPayload.builder()
                    .time(LocalDateTime.now())
                    .type(inboxType)
                    .subject(payload.getSubject()).content(payload.getContent())
                    .from("1").tos(tos)
                    .extInfo(payload.getExtInfo())
                    .build();
            logger.info("[IM-SNS] INBOX payload: {}", inboxPayload);
            inboxPusher.push(inboxPayload);
            logger.info("[IM-SNS] INBOX message SENT.");
        } catch (Throwable e) {
            logger.error("[IM-SNS] INBOX message sent FAILED.", e);
        }
    }
}
