package com.elitesland.cbpl.sns.inbox.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
@Component
public class InboxUtil {

    /**
     * 从内容中获取跳转链接
     * @param msgContent
     * @return
     */
    public String getTempLinkUrl(String msgContent) {
        Pattern pattern = Pattern.compile("(?<=(href=\\\")).*(?=\\\")");
        Matcher matcher = pattern.matcher(msgContent);
        String url = "";
        if (matcher.find()) {
            url = matcher.group();
            logger.info("[IM-MSG-TMPL] Link url:{}", url);
        }
        return url;
    }
}
