package com.elitesland.cbpl.sns.inbox.vo.resp;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.vo.save.InboxSaveParamVO;
import lombok.Builder;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;

/**
 * 站内消息内容
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Data
@Builder
public class InboxRespVO implements InboxSaveParamVO {

    /**
     * 事件ID
     */
    @Id
    private String id;

    /**
     * 生成时间
     */
    private LocalDateTime time;

    /**
     * 类型
     */
    private InboxType type;

    /**
     * 标题
     */
    private String subject;

    /**
     * 是否有值
     */
    private Map<String, Object> read;

    /**
     * 是否已读
     */
    private Boolean readFlag;

    /**
     * 内容
     */
    private String content;

    /**
     * 发信人ID
     */
    private String from;

    private String fromName;

    /**
     * 收信人ID集
     */
    private Set<String> tos;

    private String toNames;

    /**
     * 扩展信息(注意保持写入与读取的类型一致性)
     */
    private Object extInfo;

    /**
     * 消息类型
     */
//    private String msgTypeName;
}
