package com.elitesland.cbpl.sns.inbox.vo.save;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.tool.websocket.domain.NotifierPayload;

import java.io.Serializable;
import java.time.temporal.TemporalAccessor;

/**
 * 站内消息内容
 *
 * @author eric.hao
 * @since 2022/09/14
 */
public interface InboxSaveParamVO extends NotifierPayload, Serializable {

    /**
     * @return 消息ID
     */
    String getId();

    /**
     * @return 消息类型
     */
    InboxType getType();

    /**
     * @return 产生时间
     */
    TemporalAccessor getTime();

    /**
     * @return 扩展信息
     */
    Object getExtInfo();
}
