package com.elitesland.cbpl.sns.mail.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashSet;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "cbpl.im.email")
public class EmailProperties {

    /**
     * 是否启用 默认关闭
     */
    private boolean enabled = false;

    /**
     * 管理员用户ID
     */
    private String adminId;

    /**
     * 调试模式 默认关闭：enabled=true 时生效
     */
    private boolean debugger = false;

    /**
     * 用户id白名单：debugger=true 时生效<br/>
     * 即debugger模式下，只有白名单中的用户可以收到邮件通知
     */
    private Set<String> whiteList = new HashSet<>();
}
