package com.elitesland.cbpl.sns.mail.controller;

import com.elitesland.cbpl.sns.mail.service.MailService;
import com.elitesland.cbpl.sns.notifier.vo.payload.SnsPayload;
import com.elitesland.cbpl.sns.template.vo.resp.MsgExtRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2023/04/17
 */
@Slf4j
@RestController
@RequestMapping("/demo")
@RequiredArgsConstructor
public class MailTestController {

    private final MailService mailService;

    @GetMapping("/mail/user/send")
    public void sendByUserId(String userId) {
        Set<String> recipients = Collections.singleton(userId);
        SnsPayload payload = SnsPayload.of("测试邮件", "Hello World.", new MsgExtRespVO());
        mailService.sendByUserId(recipients, payload);
    }

    @GetMapping("/mail/send")
    public void sendByEmail(String email) {
        Set<String> recipients = Collections.singleton(email);
        SnsPayload payload = SnsPayload.of("测试邮件", "Hello World.", new MsgExtRespVO());
        mailService.sendByEmail(recipients, payload);
    }
}