package com.elitesland.cbpl.sns.mail.iam;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.cbpl.sns.rmi.system.rpc.RmiSysUserRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2023/04/17
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class UserResolverService implements UserResolver {

    private final RmiSysUserRpcService sysUserRpcService;

    @Override
    public Optional<String> resolveName(String userId) {
        SysUserDTO userDTO = sysUserRpcService.getUserByUserId(userId);
        return Optional.ofNullable(userDTO.getLastName());
    }

    @Override
    public Optional<String> resolveMail(String userId) {
        SysUserDTO userDTO = sysUserRpcService.getUserByUserId(userId);
        return Optional.ofNullable(userDTO.getEmail());
    }
}
