package com.elitesland.cbpl.sns.mail.service;

import com.elitesland.cbpl.sns.notifier.vo.payload.SnsPayload;

import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
public interface MailService {

    /**
     * 发送邮件
     *
     * @param tos     接收人userIds（自动匹配对应用户表的邮箱字段）
     * @param payload 邮件内容
     */
    void sendByUserId(Set<String> tos, SnsPayload payload);

    /**
     * 发送邮件
     *
     * @param tos     接收人邮箱（直接给到具体邮箱）
     * @param payload 邮件内容
     */
    void sendByEmail(Set<String> tos, SnsPayload payload);
}
