package com.elitesland.cbpl.sns.mail.vo.save;

import com.elitesland.cbpl.sns.mail.domain.RecipientMethod;
import com.elitesland.cbpl.sns.mail.vo.payload.SimpleEmailPayload;
import lombok.Builder;
import lombok.Value;

import java.util.Collections;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Builder
@Value
public class DefaultMailSaveParamVO implements MailSaveParamVO {

    /**
     * 标题
     */
    private String subject;
    /**
     * 内容
     */
    private String content;

    /**
     * 内容是否是HTML
     */
    private boolean htmlContent;

    /**
     * 发信人ID
     */
    private String from;
    /**
     * 收信人ID
     */
    private String to;

    /**
     * 收信人邮箱的方式
     */
    private RecipientMethod recipientMethod;

    @Override
    public Set<String> getTos() {
        return Collections.singleton(to);
    }

    public static DefaultMailSaveParamVO of(SimpleEmailPayload payload, String from, String to) {
        return DefaultMailSaveParamVO.builder()
            .subject(payload.getSubject())
            .content(payload.getContent())
            .htmlContent(payload.isHtmlContent())
            .from(from)
            .to(to)
            .build();
    }

}
