package com.elitesland.cbpl.sns.mail.vo.save;

import com.elitesland.cbpl.sns.mail.domain.RecipientMethod;
import com.elitesland.cbpl.tool.websocket.domain.NotifierPayload;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 邮件消息内容
 *
 * @author eric.hao
 * @since 2022/09/15
 */
public interface MailSaveParamVO extends NotifierPayload {

    /**
     * @return 信件内容
     */
    default String getContentText() {
        return String.valueOf(getContent());
    }

    /**
     * @return 内容格式是否为HTML？
     */
    default boolean isHtmlContent() {
        return false;
    }

    /**
     * @return 回信邮箱(为空时即为发信人邮箱)
     */
    default Optional<String> getReplyTo() {
        return Optional.empty();
    }

    /**
     * @return 抄送方
     */
    default Set<String> getCcs() {
        return Collections.emptySet();
    }

    /**
     * @return 附件
     */
    default List<Path> getAttachments() {
        return Collections.emptyList();
    }

    /**
     * @return 有附件？
     */
    default boolean hasAttachments() {
        return !getAttachments().isEmpty();
    }

    /**
     * 读取收信人邮箱的方式，会影响getTos的应用场景
     * @return 收信人邮箱的方式
     */
    RecipientMethod getRecipientMethod();
}
