package com.elitesland.cbpl.sns.notifier.domain;

import com.elitesland.cbpl.sns.notifier.vo.payload.SnsPayload;
import lombok.Data;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 消息模板
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Data
@RequiredArgsConstructor(staticName = "of")
public class SnsChoice {

    /**
     * 站内信消息
     */
    @NonNull
    private SnsPayload inboxContent;

    /**
     * 邮件消息
     */
    @NonNull
    private SnsPayload emailContent;

    /**
     * 微信消息
     */
    @NonNull
    private SnsPayload wechatContent;

    public SnsPayload inboxOf() {
        return inboxContent;
    }

    public SnsPayload emailOf() {
        return emailContent;
    }

    public SnsPayload wechatOf() {
        return wechatContent;
    }
}
