package com.elitesland.cbpl.sns.notifier.service;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;

import java.util.Set;

/**
 * 消息模板
 *
 * @author eric.hao
 * @since 2022/09/15
 */
public interface SnsService {

    /**
     * 发送消息
     *
     * @param inboxType 站内信类型
     * @param msgCode   消息类型
     * @param tos       接收人userIds
     * @param msgData   消息内容上下文
     */
    void sendMessage(InboxType inboxType, String msgCode, Set<String> tos, Object msgData);

    /**
     * 仅发送邮件消息
     *
     * @param inboxType 站内信类型
     * @param msgCode   消息类型
     * @param tos       接收人邮箱
     * @param msgData   消息内容上下文
     */
    void sendExtraEmail(InboxType inboxType, String msgCode, Set<String> tos, Object msgData);
}
