package com.elitesland.cbpl.sns.notifier.vo.payload;

import com.elitesland.cbpl.sns.template.vo.resp.MsgExtRespVO;
import lombok.Data;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Data
@RequiredArgsConstructor(staticName = "of")
public class SnsPayload {

    /**
     * 标题
     */
    @NonNull
    private String subject;

    /**
     * 内容
     */
    @NonNull
    private String content;

    /**
     * 业务类型
     */
    @NonNull
    private MsgExtRespVO extInfo;

    public static SnsPayload empty() {
        return SnsPayload.of("", "", new MsgExtRespVO());
    }

    /**
     * 消息内容是否可用?
     */
    public boolean isValid() {
        return StringUtils.isNotBlank(subject) &&
            StringUtils.isNotBlank(content);
    }
}
