package com.elitesland.cbpl.sns.rmi.system.rpc;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/6
 */
@Component
@Log4j2
@RequiredArgsConstructor
public class RmiSysUserRpcService {

    private final SysUserRpcService sysUserRpcService;

    public SysUserDTO getUserByUserId(String userId) {
        logger.info("调用系统域-通过用户Id查询账号方法,时间：{}，入参：{}", LocalDateTime.now(), userId);
        try {
            ApiResult<SysUserDTO> sysUser = sysUserRpcService.getUserById(userId);
            if (sysUser != null && sysUser.isSuccess()) {
                return sysUser.getData();
            }
        } catch (Exception e) {
            logger.error("查询用户错误:", e);
            throw new BusinessException("系统域服务异常", e);
        }
        return null;
    }
}
