package com.elitesland.cbpl.sns.template.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Entity
@Table(name = "sns_msg_template")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "sns_msg_template", comment = "消息模板")
@Data
@Accessors(chain = true)
public class MsgTemplateDO extends BaseModel implements Serializable {

    @Comment(value = "模板编码")
    @Column()
    private String tmplCode;

    @Comment(value = "模板名称")
    @Column()
    private String tmplName;

    @Comment(value = "模板类型(邮件、站内信、微信、短信)")
    @Column()
    private String tmplType;

    @Comment(value = "业务类型")
    @Column()
    private String bizType;

    @Comment(value = "消息标题模板(SpEL)")
    @Column()
    private String subject;

    @Comment(value = "消息内容模板(SpEL)")
    @Column()
    private String content;

    @Comment(value = "描述")
    @Column()
    private String tmplDesc;
}
