package com.elitesland.cbpl.sns.template.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Entity
@Table(name = "sns_msg_template_link")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "sns_msg_template_link", comment = "模板链接")
@Data
@Accessors(chain = true)
public class MsgTemplateLinkDO extends BaseModel implements Serializable {

    @Comment(value = "编码")
    @Column()
    private String linkCode;

    @Comment(value = "值")
    @Column()
    private String linkVal;

    @Comment(value = "小程序链接")
    @Column()
    private String linkVal2;
}
