package com.elitesland.cbpl.sns.template.repo;

import com.elitesland.cbpl.sns.template.entity.MsgTemplateDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
public interface MsgTemplateRepo extends JpaRepository<MsgTemplateDO, Long>, QuerydslPredicateExecutor<MsgTemplateDO> {

    /**
     * 消息模板
     *
     * @param tmplCode 模板编码
     * @param tmplType 业务类型
     * @return 模板
     */
    MsgTemplateDO findByTmplCodeAndTmplType(String tmplCode, String tmplType);
}
