package com.elitesland.cbpl.sns.template.service;

import com.elitesland.cbpl.sns.notifier.vo.payload.SnsPayload;
import com.elitesland.cbpl.sns.template.convert.MsgTemplateConvert;
import com.elitesland.cbpl.sns.template.entity.MsgTemplateDO;
import com.elitesland.cbpl.sns.template.repo.MsgTemplateLinkRepo;
import com.elitesland.cbpl.sns.template.repo.MsgTemplateRepo;
import com.elitesland.cbpl.sns.template.util.MsgContext;
import com.elitesland.cbpl.sns.template.util.MsgTemplateUtil;
import com.elitesland.cbpl.sns.template.vo.resp.MsgExtRespVO;
import com.elitesland.cbpl.sns.template.vo.resp.MsgTemplateRespVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class MsgTemplateServiceImpl implements MsgTemplateService {

    private final static ExpressionParser parser = new SpelExpressionParser();

    private final MsgTemplateRepo msgTemplateRepo;
    private final MsgTemplateLinkRepo msgTemplateLinkRepo;
    private final MsgTemplateUtil templateUtil;

    @Override
    public SnsPayload msgOf(String tmplCode, String tmplType, Object tmplCtx) {
        MsgTemplateDO template = msgTemplateRepo.findByTmplCodeAndTmplType(tmplCode, tmplType);
        MsgTemplateRespVO msgTmplDef = MsgTemplateConvert.INSTANCE.doToVO(template);
        if (msgTmplDef == null) {
            logger.info("[IM-MSG-TMPL] not found template, CODE = {}, TYPE = {}.", tmplCode, tmplType);
            return SnsPayload.empty();
        }
        MsgContext msgContext = new MsgContext(tmplCtx, msgTemplateLinkRepo.findAll());
        var extInfo = new MsgExtRespVO();
        extInfo.setLinkUrl(templateUtil.getTempLinkUrl(msgTmplDef.getContent(msgContext)));
        extInfo.setEventType(StringUtils.isNotEmpty(msgTmplDef.getMsgType(msgContext)) ? msgTmplDef.getMsgType(msgContext) : tmplCode);
        extInfo.setMsgTypeName(msgTmplDef.getTmplName());
        extInfo.setDocId(getDocId(msgContext));
        extInfo.setDocNo(getDocNo(msgContext));
        var msg = SnsPayload.of(msgTmplDef.getSubject(msgContext), msgTmplDef.getContent(msgContext), extInfo);
        logger.debug("[IM-MSG-TMPL] Build message:{}", msg);
        return msg;
    }

    public String getDocId(Object ctx) {
        try {
            return parser.parseExpression("ctx['id']").getValue(ctx, String.class);
        } catch (Exception e) {
            logger.error("[IM-MSG-TMPL] get docId exception:{}", ExceptionUtils.formatException(e));
        }
        return null;
    }

    public String getDocNo(Object ctx) {
        try {
            return parser.parseExpression("ctx['docNo']").getValue(ctx, String.class);
        } catch (Exception e) {
            logger.error("[IM-MSG-TMPL] get docNo exception:{}", ExceptionUtils.formatException(e));
        }
        return null;
    }

}
