package com.elitesland.cbpl.sns.template.util;

import com.elitesland.cbpl.sns.template.entity.MsgTemplateLinkDO;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Data
@RequiredArgsConstructor
public class MsgContext {

    /**
     * @param ta 时间
     * @param tp 格式
     * @return 格式化后的时间
     */
    public static String t(TemporalAccessor ta, String tp) {
        return DateTimeFormatter.ofPattern(tp).format(ta);
    }

    /**
     * 当前时间
     */
    private final LocalDateTime now = LocalDateTime.now();

    /**
     * @param tp 格式
     * @return 格式化后的当前时间
     */
    public String t(String tp) {
        return t(now, tp);
    }

    private final static ExpressionParser parser = new SpelExpressionParser();

    /**
     * @param settingCode 设置编码
     * @return 格式化后的时间
     */
    public final String urlPart(String settingCode) {
        logger.debug("[IM-MSG-TMPL-CTX] - Setting code:{}, all url parts:{}.", settingCode, this.getUrlParts());
        val urlPart = this.getUrlParts().stream().filter(u -> u.getLinkCode().equals(settingCode)).findAny();
        if (urlPart.isEmpty()) {
            throw new IllegalArgumentException("[IM-MSG-TMPL-CTX] - Invalid setting code:" + settingCode);
        }
        return parser.parseExpression(urlPart.get().getLinkVal()).getValue(ctx, String.class);
    }

    /**
     * 业务上下文数据
     */
    private final Object ctx;

    /**
     * 连接片段
     */
    private final List<MsgTemplateLinkDO> urlParts;
}
