package com.elitesland.cbpl.sns.template.vo.resp;

import lombok.Data;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

import java.time.LocalDateTime;

/**
 * 消息模板
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Data
public class MsgTemplateRespVO {

    /**
     * 主键
     */
    private Long id;

    /**
     * 模板编码
     */
    private String tmplCode;

    /**
     * 模板名称
     */
    private String tmplName;

    /**
     * 模板类型(邮件、站内信、微信、短信)
     */
    private String tmplType;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 消息标题模板(SpEL)
     */
    private String subject;

    /**
     * 消息内容模板(SpEL)
     */
    private String content;

    /**
     * 事件类型
     */
    private String msgType;

    /**
     * 更新时间
     */
    private LocalDateTime modifyTime;

    /**
     * 描述
     */
    private String tmplDesc;

    private final static ExpressionParser parser = new SpelExpressionParser();

    public String getSubject(Object ctx) {
        return parser.parseExpression(subject).getValue(ctx, String.class);
    }

    public String getContent(Object ctx) {
        return parser.parseExpression(content).getValue(ctx, String.class);
    }

    public String getMsgType(Object ctx) {
        return parser.parseExpression(msgType).getValue(ctx, String.class);
    }
}
