package com.elitesland.cbpl.unicom.annotation;

import org.springframework.beans.factory.annotation.Autowired;

import java.lang.annotation.*;

/**
 * @author eric.hao
 * @since 2023/02/06
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Autowired
public @interface UnicomReference {

    String value() default "";

    /**
     * Dubbo Version<br/>
     * 仅在调用方式为DUBBO时生效<br/>
     * 等价于 @DubboReference(version = "1.0.0") 的版本号
     */
    String dv() default "";
}

