package com.elitesland.cbpl.unicom.config;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;

/**
 * 业务域 - 调用方式的相关配置
 *
 * @author eric.hao
 * @since 2023/05/04
 */
@Data
public class InvokeModeConfig {

    /**
     * 业务领域 - 名称
     */
    private String name;

    /**
     * 业务领域 - 部署的服务名称<br/>
     * 一般用于 femas、nacos 的服务名称
     */
    private String serviceName;

    /**
     * 调用方式
     */
    @Enumerated(EnumType.STRING)
    private InvokeMode invokeMode;

    /**
     * 实际调用的服务名称
     */
    public String getInvokeName() {
        return StringUtils.defaultIfEmpty(serviceName, name);
    }

    /**
     * 默认执行的调用方式：<br/>
     * 1. 有对应配置，使用配置中的调用方式<br/>
     * 2. 没有对应配置，则判断@Unicom中domain参数值：<br/>
     *  - 2.1 domain为空，则默认使用JVM方式调用本地方法<br/>
     *  - 2.2 domain不为空，则默认使用Feign方式进行远程调用<br/>
     */
    public static InvokeMode defaultMode(InvokeModeConfig domainMode, String domainName) {
        if (ObjectUtil.isNotNull(domainMode)) {
            return domainMode.getInvokeMode();
        }
        return StringUtils.isBlank(domainName) ? InvokeMode.JVM : InvokeMode.FEIGN;
    }
}
