package com.elitesland.cbpl.unicom.domain;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2023/02/08
 */
public enum InvokeMode {

    /**
     * 调用方式
     */
    JVM("本地调用"),
    DUBBO("Dubbo"),
    FEIGN("Feign"),
    ;

    public String getCode() {
        return name();
    }

    @Getter
    private final String desc;

    InvokeMode(String desc) {
        this.desc = desc;
    }

    public static InvokeMode fromCode(String mode) {
        for (InvokeMode e : InvokeMode.values()) {
            if (e.getCode().equals(mode)) {
                return e;
            }
        }
        return JVM;
    }
}

