package com.elitesland.cbpl.cloudt.web.exception;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 异常处理器
 *
 * @author eric.hao
 * @since 2024/09/24
 */
@Slf4j
@RestControllerAdvice
public class ServerExceptionHandler {

    /**
     * 处理自定义异常
     */
    @ExceptionHandler(PhoenixException.class)
    public HttpResult<String> handleRenException(PhoenixException ex) {
        return HttpResult.internalServerError(ex.getMessage());
    }

    /**
     * SpringMVC参数绑定，Validator校验不正确
     */
    @ExceptionHandler(BindException.class)
    public HttpResult<String> bindException(BindException ex) {
        FieldError fieldError = ex.getFieldError();
        assert fieldError != null;
        return HttpResult.error(fieldError.getDefaultMessage());
    }

    @ExceptionHandler(Exception.class)
    public HttpResult<String> handleException(Exception ex) {
        log.error(ex.getMessage(), ex);
        return HttpResult.internalServerError(ex.getMessage());
    }
}